package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 订单附件信息(OrderFile)实体类
 * 附件，按一个订单可以有多个附件来实现。
 *
 * @author sunx
 * @since 2021-12-28 15:18:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_file")
@Table(name = "dms_order_file")
@ApiModel(value = "OrderFile", description = "订单附件信息")
@org.hibernate.annotations.Table(appliesTo = "dms_order_file", comment = "订单附件信息")
public class OrderFile extends AppEntity {
  private static final long serialVersionUID = -7180726373997054935L;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", length = 255, columnDefinition = "varchar(255) COMMENT '订单编码'")
  private String orderCode;

  /**
   * 文件唯一识别号（存venus保存后的id值）
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name="originalFileName" , value="原始文件名")
  @TableField(value = "original_name")
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '原始文件名'")
  private String originalFileName;

  /**
   * 图片类型
   */
  @ApiModelProperty("图片类型")
  @Column(name = "type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片类型 '")
  private String type;
}
