package com.biz.crm.dms.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.AppEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 订单的总的记账项目（该扣项目、支付项目）
 * 一个订单上的结算信息会在这里取数据。
 * 一条信息就是一项该【扣减/支付】的金额信息
 * 【政策优惠金额、货补费用抵扣、折扣费用抵扣、预付款支付、授信支付】
 *
 * @author sunx
 * @since 2021-12-28 15:18:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_order_pay")
@Table(name = "dms_order_pay")
@ApiModel(value = "OrderPay", description = "订单支付明细")
@org.hibernate.annotations.Table(appliesTo = "dms_order_pay", comment = "订单支付明细")
public class OrderPay extends AppEntity {
  private static final long serialVersionUID = -6795018781951048477L;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @Column(name = "order_code", length = 255, columnDefinition = "varchar(255) COMMENT '订单编码'")
  private String orderCode;

  /**
   * 项目组类型：【0该扣项目、1支付项目】
   */
  @ApiModelProperty("项目组类型：【0该扣项目、1支付项目】")
  @Column(name = "item_group_type", columnDefinition = "bit(1) COMMENT '项目组类型：【0该扣项目、1支付项目】'")
  private Boolean itemGroupType;

  /**
   * 项目组的key
   */
  @ApiModelProperty("项目组的key")
  @Column(name = "item_group_key", length = 32, columnDefinition = "varchar(32) COMMENT '项目组的key'")
  private String itemGroupKey;

  /**
   * 项目key
   */
  @ApiModelProperty("项目key")
  @Column(name = "item_key", length = 32, columnDefinition = "varchar(32) COMMENT '项目key'")
  private String itemKey;

  /**
   * 项目名称
   */
  @ApiModelProperty("项目名称")
  @Column(name = "item_name", length = 32, columnDefinition = "varchar(32) COMMENT '项目名称'")
  private String itemName;

  /**
   * 项目金额
   */
  @ApiModelProperty("项目金额")
  @Column(name = "item_amount", columnDefinition = "decimal(20,4) COMMENT '项目金额'")
  private BigDecimal itemAmount;

  /**
   * 订单主信息
   */
  @ApiModelProperty("订单主信息")
  @TableField(exist = false)
  @Transient
  private Order order;

}
