package com.biz.crm.dms.business.order.local.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品监听实现
 * 上下架启禁用 改变常够清单中记录的商品是否可用（isUsable 字段）
 *
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月22日 14:16:00
 */
@Component
public class ProductStatusEventListenerImpl implements ProductEventListener {

  @Autowired
  private PurchaseHistoryService purchaseHistoryService;

  @Override
  public void onUpdate(ProductEventDto productEventDto) {
    ProductVo vo = productEventDto.getNewest();
    //同步更新可购清单商品信息
    PurchaseHistory purchaseHistory =new PurchaseHistory();
    purchaseHistory.setGoodsCode(vo.getProductCode());
    purchaseHistory.setGoodsName(vo.getProductName());
    purchaseHistory.setSpec(vo.getSpec());
    purchaseHistory.setUnite(vo.getSaleUnit());
    purchaseHistoryService.updateByProductCode(purchaseHistory);
    //改变常够清单商品是否可用
    this.judgeUsable(vo);
  }

  @Override
  public void onEnable(ProductSingleEventDto productSingleEventDto) {
    ProductVo vo = JsonUtils.convert(productSingleEventDto.getNewest(), ProductVo.class);
    this.judgeUsable(vo);
  }

  @Override
  public void onDisable(ProductSingleEventDto productSingleEventDto) {
    ProductVo vo = JsonUtils.convert(productSingleEventDto.getNewest(), ProductVo.class);
    this.judgeUsable(vo);
  }

  @Override
  public void onUpShelf(ProductSingleEventDto productSingleEventDto) {
    ProductVo vo = JsonUtils.convert(productSingleEventDto.getNewest(), ProductVo.class);
    this.judgeUsable(vo);
  }

  @Override
  public void onDownShelf(ProductSingleEventDto productSingleEventDto) {
    ProductVo vo = JsonUtils.convert(productSingleEventDto.getNewest(), ProductVo.class);
    this.judgeUsable(vo);
  }

  /**
   * 判断是否可用
   * 上架并且启用的商品为可用
   *
   * @param vo
   */
  private void judgeUsable(ProductVo vo) {
    String enableStatus = vo.getEnableStatus();
    String isShelf = vo.getIsShelf();
    String productCode = vo.getProductCode();
    //只有上架并且启用的才可用
    if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus) && IsShelfEnum.UP.getCode().equals(isShelf)) {
      this.purchaseHistoryService.updateUsableStatus(productCode, BooleanEnum.TRUE.getCapital());
    } else {
      //不可用
      this.purchaseHistoryService.updateUsableStatus(productCode, BooleanEnum.FALSE.getCapital());
    }
  }
}
