package com.biz.crm.dms.business.order.local.repository;


import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.mapper.OrderDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 订单明细(OrderDetail)表数据库访问层
 *
 * @author makejava
 * @since 2022-01-08 15:13:13
 */
@Component
public class OrderDetailRepository extends ServiceImpl<OrderDetailMapper, OrderDetail> {

  @Autowired(required = false)
  private OrderDetailMapper orderDetailMapper;

  /**
   * 分页查询数据
   *
   * @param pageable    分页对象
   * @param orderDetail 实体对象
   * @return
   */
  public Page<OrderDetail> findByConditions(Pageable pageable, OrderDetail orderDetail) {
    Page<OrderDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<OrderDetail> pageList = orderDetailMapper.findByConditions(page, orderDetail);
    return pageList;
  }

  /**
   * 根据订单编码删除
   * @param orderCode
   */
  public void deleteByOrderCode(String orderCode) {
    this.lambdaUpdate()
        .eq(OrderDetail::getAppCode, TenantUtils.getAppCode())
        .eq(OrderDetail::getOrderCode, orderCode)
        .remove();
  }
}

