package com.biz.crm.dms.business.order.local.repository;


import com.biz.crm.dms.business.order.local.entity.OrderFile;
import com.biz.crm.dms.business.order.local.mapper.OrderFileMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 订单附件信息(OrderFile)表数据库访问层
 *
 * @author makejava
 * @since 2022-01-08 15:13:22
 */
@Component
public class OrderFileRepository extends ServiceImpl<OrderFileMapper, OrderFile> {

  @Autowired(required = false)
  private OrderFileMapper orderFileMapper;

  /**
   * 分页查询数据
   *
   * @param pageable  分页对象
   * @param orderFile 实体对象
   * @return
   */
  public Page<OrderFile> findByConditions(Pageable pageable, OrderFile orderFile) {
    Page<OrderFile> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<OrderFile> pageList = orderFileMapper.findByConditions(page, orderFile);
    return pageList;
  }

  /**
   * 根据订单编码删除
   *
   * @param orderCode
   */
  public void deleteByOrderCode(String orderCode) {
    this.lambdaUpdate()
        .eq(OrderFile::getAppCode, TenantUtils.getAppCode())
        .eq(OrderFile::getOrderCode, orderCode)
        .remove();
  }
}

