package com.biz.crm.dms.business.order.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.mapper.PurchaseHistoryMapper;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 购买历史(PurchaseHistory)表数据库访问层
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
@Component
public class PurchaseHistoryRepository extends ServiceImpl<PurchaseHistoryMapper, PurchaseHistory> {

  @Autowired(required = false)
  private PurchaseHistoryMapper purchaseHistoryMapper;

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param purchaseHistory 实体对象
   * @return
   */
  public Page<PurchaseHistory> findByConditions(Pageable pageable, PurchaseHistoryPageDto purchaseHistory) {
    Page<PurchaseHistory> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<PurchaseHistory> pageList = this.purchaseHistoryMapper.findByConditions(page, purchaseHistory);
    return pageList;
  }

  /**
   * 根据ID集合逻辑删除
   *
   * @param idList id列表
   */
  public void deleteByIdIn(List<String> idList) {
    this.lambdaUpdate()
        .set(PurchaseHistory::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .in(PurchaseHistory::getId, idList);
  }

  /**
   * 根据 商品编码集合、租户 查询
   *
   * @param goodsCodes 商品编码
   * @param relateCode
   * @return {@link List}<{@link PurchaseHistory}>
   */
  public List<PurchaseHistory> findByGoodsCodeInAndRelateCode(List<String> goodsCodes, String relateCode) {
    List<PurchaseHistory> list = this.lambdaQuery()
        .eq(PurchaseHistory::getRelateCode, relateCode)
        .eq(PurchaseHistory::getAppCode, TenantUtils.getAppCode())
        .in(PurchaseHistory::getGoodsCode, goodsCodes)
        .list();
    return list;
  }


  /**
   * 根据id集合，让字段 times的值 +1
   *
   * @param ids id
   */
  public void updateTimesIncrementByIdIn(List<String> ids) {
    this.lambdaUpdate()
        .setSql("times = times + 1")
        .in(PurchaseHistory::getId, ids)
        .update();
  }

  /**
   * 通过商品编码查询
   * @param code
   * @return
   */
  public List<PurchaseHistory> findByGoodsCode(String code) {
    return this.lambdaQuery()
        .eq(PurchaseHistory::getGoodsCode,code)
        .list();
  }

  /**
   * 改变状态
   * @param goodsCode
   * @param isUsable
   */
  public void updateUsableStatus(String goodsCode, String isUsable) {
    this.lambdaUpdate()
        .eq(PurchaseHistory::getGoodsCode,goodsCode)
        .set(PurchaseHistory::getIsUsable,isUsable)
        .update();
  }

  public void updateByProductCode(PurchaseHistory purchaseHistory) {
    this.lambdaUpdate()
        .eq(PurchaseHistory::getGoodsCode,purchaseHistory.getGoodsCode())
        .set(PurchaseHistory::getGoodsName,purchaseHistory.getGoodsName())
        .set(PurchaseHistory::getUnite,purchaseHistory.getUnite())
        .set(PurchaseHistory::getSpec,purchaseHistory.getSpec())
        .update();
  }
}

