package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.HistoryViewQueryConfig;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 历史查看的查询配置(HistoryViewQueryConfig)表服务接口
 *
 * @author makejava
 * @since 2022-04-07 17:14:33
 */
public interface HistoryViewQueryConfigService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param HistoryViewQueryConfig 实体对象
   * @return
   */
  Page<HistoryViewQueryConfig> findByConditions(Pageable pageable, HistoryViewQueryConfig HistoryViewQueryConfig);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  HistoryViewQueryConfig findById(String id);
  
   /**
   * 新增数据
   * @param HistoryViewQueryConfig 实体对象
   * @return 新增结果
   */
  HistoryViewQueryConfig create(HistoryViewQueryConfig HistoryViewQueryConfig);
  
   /**
   * 修改新据
   * @param HistoryViewQueryConfig 实体对象
   * @return 修改结果
   */
  HistoryViewQueryConfig update(HistoryViewQueryConfig HistoryViewQueryConfig);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);


  /**
   * 根据租户查询
   *
   * @return {@link HistoryViewQueryConfig}
   */
  HistoryViewQueryConfig findByCurrentCustomerCode(String relateCode);

}

