package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.entity.OrderDetailPay;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单明细支付明细(OrderDetailPay)表服务接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:14
 */
public interface OrderDetailPayService {

  /**
   * 分页查询数据
   *
   * @param pageable       分页对象
   * @param orderDetailPay 实体对象
   * @return
   */
  Page<OrderDetailPay> findByConditions(Pageable pageable, OrderDetailPay orderDetailPay);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  OrderDetailPay findById(String id);

  /**
   * 新增数据
   *
   * @param orderDetailPay 实体对象
   * @return 新增结果
   */
  OrderDetailPay create(OrderDetailPay orderDetailPay);

  /**
   * 修改新据
   *
   * @param orderDetailPay 实体对象
   * @return 修改结果
   */
  OrderDetailPay update(OrderDetailPay orderDetailPay);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 新增数据（批量）
   * @param orderDetails
   */
  void createBatch(List<OrderDetail> orderDetails);

  /**
   * 根据订单编码删除
   *
   * @param orderCode
   */
  void deleteByOrderCode(String orderCode);
}

