package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderFile;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单附件信息(OrderFile)表服务接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:19
 */
public interface OrderFileService {

  /**
   * 分页查询数据
   *
   * @param pageable  分页对象
   * @param orderFile 实体对象
   * @return
   */
  Page<OrderFile> findByConditions(Pageable pageable, OrderFile orderFile);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  OrderFile findById(String id);

  /**
   * 新增数据
   *
   * @param orderFile 实体对象
   * @return 新增结果
   */
  OrderFile create(OrderFile orderFile);

  /**
   * 修改新据
   *
   * @param orderFile 实体对象
   * @return 修改结果
   */
  OrderFile update(OrderFile orderFile);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 新增数据（批量）
   * @param order
   */
  void createBatch(Order order);

  /**
   * 根据订单编码删除
   *
   * @param orderCode
   */
  void deleteByOrderCode(String orderCode);
}

