package com.biz.crm.dms.business.order.local.service;


import com.biz.crm.dms.business.order.local.entity.Order;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPaginationDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单主信息(Order)表服务接口
 *
 * @author makejava
 * @since 2022-01-08 15:13:07
 */
public interface OrderService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param order    实体对象
   * @return
   */
  Page<Order> findByConditions(Pageable pageable, OrderPaginationDto order);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  Order findById(String id);

  /**
   * 新增数据
   *
   * @param order 实体对象
   * @return 新增结果
   */
  Order create(Order order);

  /**
   * 修改新据
   *
   * @param order 实体对象
   * @return 修改结果
   */
  Order update(Order order);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 根据订单编码查询
   *
   * @param orderCode
   * @return
   */
  Order findByOrderCode(String orderCode);

  /**
   * 根据订单编码 删除草稿信息
   *
   * @param orderCode
   */
  void deleteDraftByOrderCode(String orderCode);

  /**
   * 分页查询当前客户的数据
   *
   * @param pageable             分页
   * @param customerOrderPageDto 客户订单分页dto
   * @return {@link Page}<{@link Order}>
   */
  Page<Order> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto);


  /**
   * 查询可退还订单，根据客户编码
   *
   * @param relateCode 关联编码 【客户编码】
   * @return {@link List}<{@link Order}>
   */
  List<Order> findRefundableByCustomerCode(String relateCode);
}

