package com.biz.crm.dms.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.constant.LoginUserConstant;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.order.local.entity.PurchaseHistory;
import com.biz.crm.dms.business.order.local.service.PurchaseHistoryService;
import com.biz.crm.dms.business.order.sdk.dto.PurchaseHistoryPageDto;
import com.biz.crm.dms.business.order.sdk.service.PurchaseHistoryVoService;
import com.biz.crm.dms.business.order.sdk.vo.PurchaseHistoryVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 购买历史vo服务impl
 *
 * @author hefan
 * @date 2022/04/08
 */
@Service("purchaseHistoryVoService")
public class PurchaseHistoryVoServiceImpl implements PurchaseHistoryVoService {

  @Autowired(required = false)
  private PurchaseHistoryService purchaseHistoryService;
  @Autowired(required = false)
  private PriceModelVoService priceModelVoService;
  @Autowired(required = false)
  private ProductVoService productVoService;
  @Autowired(required = false)
  private ProductSpuRelateSkuVoService productSpuRelateSkuVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public Page<PurchaseHistoryVo> findByConditions(Pageable pageable, PurchaseHistoryPageDto purchaseHistory) {
    String customerCode = purchaseHistory.getRelateCode();
    Page<PurchaseHistory> page = this.purchaseHistoryService.findByConditions(pageable, purchaseHistory);
    List<PurchaseHistory> records = page.getRecords();
    Set<String> productCodeSet = records.stream()
        .filter(a -> StringUtils.isNotBlank(a.getGoodsCode()))
        .map(PurchaseHistory::getGoodsCode)
        .collect(Collectors.toSet());
    AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
    // 获取sku的信息 com.biz.crm.mdm.business.product.sdk.service.ProductVoService#findDetailsByIdsOrProductCodes
    ArrayList<String> productCodeList = Lists.newArrayList(productCodeSet);
    List<ProductVo> productList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
    Map<String,ProductVo> productCodeMap = new HashMap<>(productList.size());
    for (ProductVo productVo : productList) {
      productCodeMap.put(productVo.getProductCode(), productVo);
    }
    // 获取单价 com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService#findPrice
    FindPriceDto findPriceDto = new FindPriceDto();
    findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
    findPriceDto.setUserCode(customerCode);
    findPriceDto.setProductCodeSet(productCodeSet);
    Map<String, PriceModelVo> price = this.priceModelVoService.findPrice(findPriceDto);
    // spuCode
    List<ProductSpuRelateSkuVo> relate = productSpuRelateSkuVoService.findByProductCodes(productCodeList);
    Map<String,String> productCodeToSpuMap = new HashMap<>(relate.size());
    for (ProductSpuRelateSkuVo relateSkuVo : relate) {
      productCodeToSpuMap.put(relateSkuVo.getProductCode(), relateSkuVo.getSpuCode());
    }
    // 查询可购的商品
    Set<String> allowSaleProductCodes = this.findAllowSaleProductCodes(customerCode, productCodeList);
    // 组织返回模型
    List<PurchaseHistoryVo> list = Lists.newArrayListWithCapacity(records.size());
    for (PurchaseHistory record : records) {
      PurchaseHistoryVo vo = new PurchaseHistoryVo();
      PriceModelVo priceModelVo = price.get(record.getGoodsCode());
      if (priceModelVo != null) {
        vo.setPrice(priceModelVo.getPrice());
      }
      ProductVo productVo = productCodeMap.get(record.getGoodsCode());
      List<ProductMediaVo> pictureMediaList = productVo.getPictureMediaList();
      String fileCode = "";
      if (!CollectionUtils.isEmpty(pictureMediaList)) {
        fileCode = pictureMediaList.get(0).getId();
      }
      vo.setIsAllowsale(allowSaleProductCodes.contains(record.getGoodsCode()));
      vo.setIsShelf(productVo.getIsShelf());
      vo.setEnableStatus(productVo.getEnableStatus());
      vo.setFileCode(fileCode);
      vo.setGoodsCode(record.getGoodsCode());
      vo.setGoodsName(record.getGoodsName());
      vo.setSpec(record.getSpec());
      vo.setUnite(record.getUnite());
      vo.setTimes(record.getTimes());
      vo.setSpuCode(productCodeToSpuMap.get(record.getGoodsCode()));
      vo.setId(record.getId());
      vo.setEnableStatus(record.getEnableStatus());
      list.add(vo);
    }
    Page<PurchaseHistoryVo> result = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    result.setRecords(list);
    return result;
  }

  @Autowired(required = false)
  private AllowSaleListVoService allowSaleListVoService;

  /**
   * 找到允许出售产品Code
   *
   * @param customerCode 客户代码
   * @param productCodes 产品代码
   * @return {@link List}<{@link String}>
   */
  private Set<String> findAllowSaleProductCodes(String customerCode, List<String> productCodes) {
    ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
    dto.setBusinessCode(customerCode);
    dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    dto.setProductCodeList(productCodes);
    List<String> list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
    return Sets.newHashSet(list);
  }

}
