package com.biz.crm.dms.business.order.minimum.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.minimum.local.service.MinimumValidateMountVoService;
import com.biz.crm.dms.business.order.minimum.sdk.vo.MinimumValidateMountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 订单起订量验证方式Controller
 * @Author: zengxingwang
 * @Date: 2021/12/29 15:44
 */
@RestController
@RequestMapping("/v1/minimumValidate/validate")
@Slf4j
@Api(tags = "订单起订量：MinimumValidateMountVo：订单起订量验证方式Controller")
public class MinimumValidateMountVoController {

  @Autowired(required = false)
  private MinimumValidateMountVoService minimumValidateMountVoService;

  /**
   * 查询系统中存在的订单起订量验证方式
   */
  @ApiOperation(value = "查询系统中存在的订单起订量验证方式")
  @GetMapping(value = "/findAll")
  public Result<List<MinimumValidateMountVo>> findAll() {
    try {
      List<MinimumValidateMountVo> current = this.minimumValidateMountVoService.findAll();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
