package com.biz.crm.dms.business.order.minimum.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 订单起订量
 * @author: zengxingwang
 * @date: 2021/12/27 15:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DmsOrderMinimum", description = "订单起订量")
@Entity
@TableName("dms_order_minimum")
@Table(name = "dms_order_minimum")
@org.hibernate.annotations.Table(appliesTo = "dms_order_minimum", comment = "订单起订量")
public class DmsOrderMinimum extends TenantFlagOpEntity {

  /**
   * 产品名称
   */
  @ApiModelProperty(name = "productName", value = "产品名称")
  @Column(name = "product_name", length = 255, columnDefinition = "VARCHAR(255) NOT NULL COMMENT '产品名称'")
  private String productName;

  /**
   * 产品编码
   */
  @ApiModelProperty(name = "productCode", value = "产品编码")
  @Column(name = "product_code", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '产品编码'")
  private String productCode;

  /**
   * 对象类型
   */
  @ApiModelProperty(name = "type", value = "对象类型")
  @Column(name = "type", length = 4, columnDefinition = "VARCHAR(4) COMMENT '对象类型'")
  private String type;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "customerCode", value = "客户编码")
  @Column(name = "customer_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "customerName", value = "客户名称")
  @Column(name = "customer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
  private String customerName;

  /**
   * 组织编码
   */
  @ApiModelProperty(name = "orgCode", value = "组织编码")
  @Column(name = "org_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '组织编码'")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty(name = "orgName", value = "组织名称")
  @Column(name = "org_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
  private String orgName;

  /**
   * 校验方式
   */
  @ApiModelProperty(name = "checkType", value = "校验方式")
  @Column(name = "check_type", length = 255, columnDefinition = "VARCHAR(255) NOT NULL COMMENT '校验方式'")
  private String checkType;

  /**
   * 单位
   */
  @ApiModelProperty(name = "unit", value = "单位")
  @Column(name = "unit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '单位'")
  private String unit;

  /**
   * 起订量
   */
  @ApiModelProperty(name = "minimum", value = "起订量")
  @Column(name = "minimum", columnDefinition = "decimal(20,4) NOT NULL COMMENT '起订量'")
  private BigDecimal minimum;
}
