package com.biz.crm.dms.business.order.minimum.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 订单起订量(DmsOrderMinimum)mybatis的mapper
 *
 * @author zengxingwang
 * @since 2021-12-27 17:18:47
 */
public interface DmsOrderMinimumMapper extends BaseMapper<DmsOrderMinimum> {

  /**
   * 分页条件查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<DmsOrderMinimum> findByConditions(@Param("page") Page<DmsOrderMinimum> page, @Param("dto") DmsOrderMinimum dto);

  /**
   * 根据客户或则组织、产品查询
   * @param customerCode
   * @param orgCode
   * @param status
   * @return
   */
  List<DmsOrderMinimum> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(@Param("customerCode") String customerCode, @Param("orgCode") String orgCode, @Param("status") String status, @Param("productCodes") Set<String> productCodes);
}

