package com.biz.crm.dms.business.order.minimum.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.repository.DmsOrderMinimumRepository;
import com.biz.crm.dms.business.order.minimum.local.service.DmsOrderMinimumService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 订单起订量(DmsOrderMinimum)接口实现
 *
 * @author zengxingwang
 * @since 2021-12-27 17:18:47
 */
@Service("dmsOrderMinimumService")
public class DmsOrderMinimumServiceImpl implements DmsOrderMinimumService {

  @Autowired(required = false)
  private DmsOrderMinimumRepository dmsOrderMinimumRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 分页条件查询
   * @param pageable
   * @param dmsOrderMinimum
   * @return
   */
  @Override
  public Page<DmsOrderMinimum> findByConditions(Pageable pageable, DmsOrderMinimum dmsOrderMinimum) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dmsOrderMinimum)) {
      dmsOrderMinimum = new DmsOrderMinimum();
    }
    dmsOrderMinimum.setTenantCode(TenantUtils.getTenantCode());
    return this.dmsOrderMinimumRepository.findByConditions(pageable, dmsOrderMinimum);
  }

  /**
   * 查询详情
   * @param id
   * @return
   */
  @Override
  public DmsOrderMinimum findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.dmsOrderMinimumRepository.getById(id);
  }

  /**
   * 创建
   * @param dmsOrderMinimum
   * @return
   */
  @Transactional
  @Override
  public DmsOrderMinimum create(DmsOrderMinimum dmsOrderMinimum) {
    this.createValidate(dmsOrderMinimum);
    LoginDetails loginUser = loginUserService.getLoginUser();
    Date date = new Date();
    dmsOrderMinimum.setTenantCode(TenantUtils.getTenantCode());
    dmsOrderMinimum.setCreateAccount(loginUser.getAccount());
    dmsOrderMinimum.setCreateName(loginUser.getUsername());
    dmsOrderMinimum.setCreateTime(date);
    dmsOrderMinimum.setModifyAccount(loginUser.getAccount());
    dmsOrderMinimum.setModifyName(loginUser.getUsername());
    dmsOrderMinimum.setModifyTime(date);
    this.dmsOrderMinimumRepository.saveOrUpdate(dmsOrderMinimum);
    return dmsOrderMinimum;
  }

  /**
   * 修改
   * @param dmsOrderMinimum
   * @return
   */
  @Transactional
  @Override
  public DmsOrderMinimum update(DmsOrderMinimum dmsOrderMinimum) {
    this.updateValidate(dmsOrderMinimum);
    LoginDetails loginUser = loginUserService.getLoginUser();
    dmsOrderMinimum.setModifyAccount(loginUser.getAccount());
    dmsOrderMinimum.setModifyName(loginUser.getUsername());
    dmsOrderMinimum.setModifyTime(new Date());
    this.dmsOrderMinimumRepository.saveOrUpdate(dmsOrderMinimum);
    return dmsOrderMinimum;
  }

  /**
   * 删除
   * @param ids
   */
  @Transactional
  @Override
  public void delete(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除时数据不能为空");
    this.dmsOrderMinimumRepository.removeByIds(ids);
  }

  /**
   * 创建数据验证
   * @param dmsOrderMinimum
   */
  private void createValidate(DmsOrderMinimum dmsOrderMinimum) {
    Validate.notNull(dmsOrderMinimum, "创建时，数据不能为空");
    dmsOrderMinimum.setId(null);
    Validate.notBlank(dmsOrderMinimum.getCheckType(), "创建时，校验方式不能为空");
    Validate.notNull(dmsOrderMinimum.getMinimum(), "创建时，起订量不能为空");
    Validate.notBlank(dmsOrderMinimum.getProductCode(), "创建时，产品编码不能为空");
    Validate.notBlank(dmsOrderMinimum.getProductName(), "创建时，产品名称不能为空");
    DmsOrderMinimum orderMinimum = this.findByProductAndCustomerOrOrg(dmsOrderMinimum.getProductCode(), dmsOrderMinimum.getCustomerCode(), dmsOrderMinimum.getOrgCode());
    if (orderMinimum != null) {
      Validate.isTrue(!orderMinimum.getEnableStatus().equals(EnableStatusEnum.DISABLE.getCode()), "%s,数据已禁用，请启用", orderMinimum.getProductName());
      Validate.isTrue(!orderMinimum.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode()) , "%s,数据重复，请检查", orderMinimum.getProductName());
    }

  }

  /**
   * 修改数据验证
   * @param dmsOrderMinimum
   */
  private void updateValidate(DmsOrderMinimum dmsOrderMinimum) {
    Validate.notNull(dmsOrderMinimum, "编辑时，数据不能为空");
    Validate.notBlank(dmsOrderMinimum.getId(), "编辑时，数据不能为空");
    Validate.notBlank(dmsOrderMinimum.getCheckType(), "编辑时，校验方式不能为空");
    Validate.notNull(dmsOrderMinimum.getMinimum(), "编辑时，起订量不能为空");
    Validate.notBlank(dmsOrderMinimum.getProductCode(), "编辑时，产品编码不能为空");
    Validate.notBlank(dmsOrderMinimum.getProductName(), "编辑时，产品名称不能为空");
    DmsOrderMinimum orderMinimum = this.findByProductAndCustomerOrOrg(dmsOrderMinimum.getProductCode(), dmsOrderMinimum.getCustomerCode(), dmsOrderMinimum.getOrgCode());
    if (orderMinimum != null) {
      Validate.isTrue(orderMinimum.getId().equals(dmsOrderMinimum.getId()), "%s,数据重复，请检查", orderMinimum.getProductName());
    }
  }

  /**
   * 启用
   * @param ids
   */
  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选中要操作的数据");
    this.dmsOrderMinimumRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
  }

  /**
   * 禁用
   * @param ids
   */
  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选中要操作的数据");
    this.dmsOrderMinimumRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
  }

  /**
   * 根据商品、客户、组织查询
   * @param ProductCode
   * @param customerCode
   * @param orgCode
   * @return
   */
  @Override
  public DmsOrderMinimum findByProductAndCustomerOrOrg(String ProductCode, String customerCode, String orgCode) {
    if(StringUtils.isBlank(ProductCode)){
      return null;
    }
    DmsOrderMinimum minimum = dmsOrderMinimumRepository.findByProductAndCustomer(ProductCode, customerCode);
    if(minimum != null){
      return minimum;
    }
    return dmsOrderMinimumRepository.findByProductAndOrg(ProductCode, orgCode);
  }

  /**
   * 根据客户或则组织、产品查询
   * @param customerCode
   * @return
   */
  @Override
  public List<DmsOrderMinimum> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(String customerCode, String orgCode, String status, Set<String> productCodes) {
    if(StringUtils.isBlank(customerCode) && StringUtils.isBlank(orgCode)){
      return null;
    }
    if(StringUtils.isBlank(status) || CollectionUtils.isEmpty(productCodes)){
      return null;
    }
    return dmsOrderMinimumRepository.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(customerCode, orgCode, status, productCodes);
  }
}

