/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.minimum.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.repository.DmsOrderMinimumRepository;
import com.biz.crm.dms.business.order.minimum.local.service.DmsOrderMinimumService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="dmsOrderMinimumService")
public class DmsOrderMinimumServiceImpl
implements DmsOrderMinimumService {
    @Autowired(required=false)
    private DmsOrderMinimumRepository dmsOrderMinimumRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<DmsOrderMinimum> findByConditions(Pageable pageable, DmsOrderMinimum dmsOrderMinimum) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)dmsOrderMinimum)) {
            dmsOrderMinimum = new DmsOrderMinimum();
        }
        dmsOrderMinimum.setTenantCode(TenantUtils.getTenantCode());
        return this.dmsOrderMinimumRepository.findByConditions(pageable, dmsOrderMinimum);
    }

    @Override
    public DmsOrderMinimum findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (DmsOrderMinimum)((Object)this.dmsOrderMinimumRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public DmsOrderMinimum create(DmsOrderMinimum dmsOrderMinimum) {
        this.createValidate(dmsOrderMinimum);
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        Date date = new Date();
        dmsOrderMinimum.setTenantCode(TenantUtils.getTenantCode());
        dmsOrderMinimum.setCreateAccount(loginUser.getAccount());
        dmsOrderMinimum.setCreateName(loginUser.getUsername());
        dmsOrderMinimum.setCreateTime(date);
        dmsOrderMinimum.setModifyAccount(loginUser.getAccount());
        dmsOrderMinimum.setModifyName(loginUser.getUsername());
        dmsOrderMinimum.setModifyTime(date);
        this.dmsOrderMinimumRepository.saveOrUpdate((Object)dmsOrderMinimum);
        return dmsOrderMinimum;
    }

    @Override
    @Transactional
    public DmsOrderMinimum update(DmsOrderMinimum dmsOrderMinimum) {
        this.updateValidate(dmsOrderMinimum);
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        dmsOrderMinimum.setModifyAccount(loginUser.getAccount());
        dmsOrderMinimum.setModifyName(loginUser.getUsername());
        dmsOrderMinimum.setModifyTime(new Date());
        this.dmsOrderMinimumRepository.saveOrUpdate((Object)dmsOrderMinimum);
        return dmsOrderMinimum;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u65f6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dmsOrderMinimumRepository.removeByIds(ids);
    }

    private void createValidate(DmsOrderMinimum dmsOrderMinimum) {
        Validate.notNull((Object)((Object)dmsOrderMinimum), (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dmsOrderMinimum.setId(null);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getCheckType(), (String)"\u521b\u5efa\u65f6\uff0c\u6821\u9a8c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dmsOrderMinimum.getMinimum(), (String)"\u521b\u5efa\u65f6\uff0c\u8d77\u8ba2\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getProductCode(), (String)"\u521b\u5efa\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getProductName(), (String)"\u521b\u5efa\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DmsOrderMinimum orderMinimum = this.findByProductAndCustomerOrOrg(dmsOrderMinimum.getProductCode(), dmsOrderMinimum.getCustomerCode(), dmsOrderMinimum.getOrgCode());
        if (orderMinimum != null) {
            Validate.isTrue((!orderMinimum.getEnableStatus().equals(EnableStatusEnum.DISABLE.getCode()) ? 1 : 0) != 0, (String)"%s,\u6570\u636e\u5df2\u7981\u7528\uff0c\u8bf7\u542f\u7528", (Object[])new Object[]{orderMinimum.getProductName()});
            Validate.isTrue((!orderMinimum.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode()) ? 1 : 0) != 0, (String)"%s,\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{orderMinimum.getProductName()});
        }
    }

    private void updateValidate(DmsOrderMinimum dmsOrderMinimum) {
        Validate.notNull((Object)((Object)dmsOrderMinimum), (String)"\u7f16\u8f91\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getCheckType(), (String)"\u7f16\u8f91\u65f6\uff0c\u6821\u9a8c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dmsOrderMinimum.getMinimum(), (String)"\u7f16\u8f91\u65f6\uff0c\u8d77\u8ba2\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getProductCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dmsOrderMinimum.getProductName(), (String)"\u7f16\u8f91\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DmsOrderMinimum orderMinimum = this.findByProductAndCustomerOrOrg(dmsOrderMinimum.getProductCode(), dmsOrderMinimum.getCustomerCode(), dmsOrderMinimum.getOrgCode());
        if (orderMinimum != null) {
            Validate.isTrue((boolean)orderMinimum.getId().equals(dmsOrderMinimum.getId()), (String)"%s,\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{orderMinimum.getProductName()});
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.dmsOrderMinimumRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.dmsOrderMinimumRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public DmsOrderMinimum findByProductAndCustomerOrOrg(String ProductCode, String customerCode, String orgCode) {
        if (StringUtils.isBlank((CharSequence)ProductCode)) {
            return null;
        }
        DmsOrderMinimum minimum = this.dmsOrderMinimumRepository.findByProductAndCustomer(ProductCode, customerCode);
        if (minimum != null) {
            return minimum;
        }
        return this.dmsOrderMinimumRepository.findByProductAndOrg(ProductCode, orgCode);
    }

    @Override
    public List<DmsOrderMinimum> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(String customerCode, String orgCode, String status, Set<String> productCodes) {
        if (StringUtils.isBlank((CharSequence)customerCode) && StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)status) || CollectionUtils.isEmpty(productCodes)) {
            return null;
        }
        return this.dmsOrderMinimumRepository.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(customerCode, orgCode, status, productCodes);
    }
}

