/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.minimum.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsService;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.service.DmsOrderMinimumService;
import com.biz.crm.dms.business.order.minimum.local.service.MinimumValidateMountVoService;
import com.biz.crm.dms.business.order.minimum.sdk.ObjectTypeEnum;
import com.biz.crm.dms.business.order.minimum.sdk.vo.MinimumValidateMountVo;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MinimumOrderVerificationStrategyImpl
implements OrderVerificationStrategy {
    @Autowired(required=false)
    private List<OrderStatisticsElementRegister> orderStatisticsElementRegisterList;
    @Autowired(required=false)
    private DmsOrderMinimumService dmsOrderMinimumService;
    @Autowired(required=false)
    private OrderStatisticsService orderStatisticsService;
    @Autowired(required=false)
    private MinimumValidateMountVoService minimumValidateMountVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TWO});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])OrderTypeEnum.values());
    }

    public Boolean required() {
        return Boolean.FALSE;
    }

    public String title() {
        return "\u8d77\u8ba2\u91cf\u6821\u9a8c";
    }

    public void execute(OrderVerificationContext context) {
        OrderTabulateDto orderTabulateDto = context.getOrderTabulateDto();
        OrderDto orderDtoIn = context.getOrderDto();
        if (ObjectUtils.isEmpty((Object)orderTabulateDto)) {
            this.execute(orderDtoIn);
        } else {
            OrderDto orderDtoOut = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)orderDtoIn, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
            OrderDto orderDtoTemp = (OrderDto)this.nebulaToolkitService.copyObjectByBlankList((Object)orderTabulateDto, OrderDto.class, HashSet.class, LinkedList.class, new String[0]);
            orderDtoOut.setOrderDetails(orderDtoTemp.getOrderDetails());
            this.execute(orderDtoOut);
        }
    }

    public void execute(OrderDto orderDto) {
        HashSet<String> codes = new HashSet<String>();
        for (OrderDetailDto vo : orderDto.getOrderDetails()) {
            codes.add(vo.getGoodsCode());
        }
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, orderDto.getRelateCode());
        Validate.notNull((Object)customerVo, (String)"\u8d77\u8ba2\u91cf\u67e5\u8be2\uff0c\u5ba2\u6237\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        HashMap<String, DmsOrderMinimum> minimumMap = new HashMap<String, DmsOrderMinimum>();
        List<DmsOrderMinimum> minimums = this.dmsOrderMinimumService.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(orderDto.getRelateCode(), customerVo.getOrgCode(), EnableStatusEnum.ENABLE.getCode(), codes);
        for (DmsOrderMinimum minimum : minimums) {
            if (minimumMap.containsKey(minimum.getProductCode())) {
                if (!ObjectTypeEnum.CUSTOMER.getDictCode().equals(minimum.getType())) continue;
                minimumMap.put(minimum.getProductCode(), minimum);
                continue;
            }
            minimumMap.put(minimum.getProductCode(), minimum);
        }
        ArrayList<DmsOrderMinimum> result = new ArrayList<DmsOrderMinimum>();
        minimumMap.forEach((key, value) -> result.add((DmsOrderMinimum)((Object)value)));
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        this.handleMinimumValidate(result, orderDto);
    }

    private void handleMinimumValidate(List<DmsOrderMinimum> result, OrderDto orderDto) {
        Map<String, List<OrderDetailDto>> productMap = orderDto.getOrderDetails().stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getGoodsCode()})).collect(Collectors.groupingBy(OrderDetailDto::getGoodsCode));
        for (DmsOrderMinimum minimum : result) {
            List<OrderDetailDto> products = productMap.get(minimum.getProductCode());
            if (CollectionUtils.isEmpty(products)) continue;
            HashSet checkTypes = Sets.newHashSet((Object[])StringUtils.split((String)minimum.getCheckType(), (String)"+"));
            List<BigDecimal> feeQuantity = this.getFeeQuantity(checkTypes, products);
            BigDecimal quantity = this.orderStatisticsService.getFeeCount(feeQuantity);
            List<MinimumValidateMountVo> all = this.minimumValidateMountVoService.findAll();
            String name = "";
            if (!CollectionUtils.isEmpty(all)) {
                for (MinimumValidateMountVo vo : all) {
                    if (!vo.getKey().equals(minimum.getCheckType())) continue;
                    name = vo.getName();
                }
            }
            Validate.isTrue((minimum.getMinimum().compareTo(quantity) < 1 ? 1 : 0) != 0, (String)"[%s]\u5546\u54c1[%s]\u8d77\u8ba2\u91cf\u4e0d\u591f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{name, minimum.getProductName()});
        }
    }

    private List<BigDecimal> getFeeQuantity(Set<String> checkTypes, List<OrderDetailDto> products) {
        Validate.isTrue((!CollectionUtils.isEmpty(checkTypes) ? 1 : 0) != 0, (String)"\u4f20\u5165\u8ba2\u5355\u7edf\u8ba1\u8303\u56f4\u8981\u7d20\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<BigDecimal> feeQuantity = new ArrayList<BigDecimal>();
        for (String checkType : checkTypes) {
            this.orderStatisticsElementRegisterList.forEach(orderStatisticsElementRegister -> {
                Map<String, List<OrderDetailDto>> map;
                List<OrderDetailDto> checkTypeProducts;
                if (orderStatisticsElementRegister.getOrderStatisticsElementCode().equals(checkType) && !CollectionUtils.isEmpty(checkTypeProducts = (map = products.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getItemType()})).collect(Collectors.groupingBy(OrderDetailDto::getItemType))).get(checkType))) {
                    BigDecimal quantity = orderStatisticsElementRegister.getFeeQuantity(checkTypeProducts);
                    feeQuantity.add(quantity);
                }
            });
        }
        return feeQuantity;
    }
}

