package com.biz.crm.dms.business.order.minimum.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.service.DmsOrderMinimumService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 订单起订量(DmsOrderMinimum)控制层
 *
 * @author zengxingwang
 * @since 2021-12-27 17:18:47
 */
@RestController
@RequestMapping("/v1/minimum/minimum")
@Slf4j
@Api(tags = "订单起订量模块：minimum：订单起订量配置信息")
public class DmsOrderMinimumController {

  @Autowired(required = false)
  private DmsOrderMinimumService dmsOrderMinimumService;

  /**
   * 分页条件查询
   * @param pageable
   * @param dmsOrderMinimum
   * @return
   */
  @ApiOperation(value = "分页条件查询")
  @GetMapping("findByConditions")
  public Result<Page<DmsOrderMinimum>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "dmsOrderMinimum", value = "订单起订量") DmsOrderMinimum dmsOrderMinimum) {
    try {
      Page<DmsOrderMinimum> page = this.dmsOrderMinimumService.findByConditions(pageable, dmsOrderMinimum);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询详情
   * @param id
   * @return
   */
  @ApiOperation(value = "ͨ查询详情")
  @GetMapping("{id}")
  public Result<DmsOrderMinimum> findById(@PathVariable @ApiParam(name = "id", value = "主键") String id) {
    try {
      DmsOrderMinimum dmsOrderMinimum = this.dmsOrderMinimumService.findById(id);
      return Result.ok(dmsOrderMinimum);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   * @param dmsOrderMinimum
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping
  public Result<DmsOrderMinimum> create(@ApiParam(name = "dmsOrderMinimum", value = "订单起订量") @RequestBody DmsOrderMinimum dmsOrderMinimum) {
    try {
      DmsOrderMinimum result = this.dmsOrderMinimumService.create(dmsOrderMinimum);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改
   * @param dmsOrderMinimum
   * @return
   */
  @ApiOperation(value = "修改")
  @PatchMapping
  public Result<DmsOrderMinimum> update(@ApiParam(name = "dmsOrderMinimum", value = "订单起订量") @RequestBody DmsOrderMinimum dmsOrderMinimum) {
    try {
      DmsOrderMinimum result = this.dmsOrderMinimumService.update(dmsOrderMinimum);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除
   * @param ids
   * @return
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键id集合") @RequestParam List<String> ids) {
    try {
      this.dmsOrderMinimumService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用", httpMethod = "PATCH")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.dmsOrderMinimumService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用", httpMethod = "PATCH")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.dmsOrderMinimumService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
