package com.biz.crm.dms.business.order.minimum.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.mapper.DmsOrderMinimumMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;


/**
 * 订单起订量(DmsOrderMinimum)持久化
 *
 * @author zengxingwang
 * @since 2021-12-27 17:18:47
 */
@Component
public class DmsOrderMinimumRepository extends ServiceImpl<DmsOrderMinimumMapper, DmsOrderMinimum> {

  @Autowired(required = false)
  private DmsOrderMinimumMapper dmsOrderMinimumMapper;

  /**
   * 分页条件查询
   * @param pageable
   * @param dmsOrderMinimum
   * @return
   */
  public Page<DmsOrderMinimum> findByConditions(Pageable pageable, DmsOrderMinimum dmsOrderMinimum) {
    Page<DmsOrderMinimum> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<DmsOrderMinimum> pageList = dmsOrderMinimumMapper.findByConditions(page, dmsOrderMinimum);
    return pageList;
  }

  /**
   * 根据主键集合，修改 enable_status
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    LambdaUpdateWrapper<DmsOrderMinimum> updateWrapper = new LambdaUpdateWrapper<>();
    updateWrapper.set(DmsOrderMinimum::getEnableStatus, enable.getCode())
            .in(DmsOrderMinimum::getId, ids);
    this.baseMapper.update(null, updateWrapper);
  }

  /**
   * 根据商品、客户查询
   * @param productCode
   * @param customerCode
   * @return
   */
  public DmsOrderMinimum findByProductAndCustomer(String productCode, String customerCode) {
    return this.lambdaQuery()
            .eq(DmsOrderMinimum::getProductCode, productCode)
            .eq(DmsOrderMinimum::getCustomerCode, customerCode)
            .one();
  }

  /**
   * 根据商品、组织查询
   * @param productCode
   * @param orgCode
   * @return
   */
  public DmsOrderMinimum findByProductAndOrg(String productCode, String orgCode) {
    return this.lambdaQuery()
            .eq(DmsOrderMinimum::getProductCode, productCode)
            .eq(DmsOrderMinimum::getOrgCode, orgCode)
            .one();
  }

  /**
   * 根据客户或则组织、产品查询
   * @param customerCode
   * @return
   */
  public List<DmsOrderMinimum> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(String customerCode, String orgCode, String status, Set<String> productCodes) {
    return this.dmsOrderMinimumMapper.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(customerCode, orgCode, status, productCodes);
  }
}

