package com.biz.crm.dms.business.order.minimum.local.service;


import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 订单起订量(DmsOrderMinimum)接口定义
 *
 * @author makejava
 * @since 2021-12-27 17:18:47
 */
public interface DmsOrderMinimumService {

  /**
   * 分页条件查询
   * @param pageable
   * @param dmsOrderMinimum
   * @return
   */
  Page<DmsOrderMinimum> findByConditions(Pageable pageable, DmsOrderMinimum dmsOrderMinimum);

  /**
   * 查询详情
   * @param id
   * @return
   */
  DmsOrderMinimum findById(String id);

  /**
   * 创建
   * @param dmsOrderMinimum
   * @return
   */
  DmsOrderMinimum create(DmsOrderMinimum dmsOrderMinimum);

  /**
   * 修改
   * @param dmsOrderMinimum
   * @return
   */
  DmsOrderMinimum update(DmsOrderMinimum dmsOrderMinimum);

  /**
   * 删除
   * @param ids
   */
  void delete(List<String> ids);

  /**
   * 启用
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 根据商品、客户、组织查询
   * @return
   */
  DmsOrderMinimum findByProductAndCustomerOrOrg(String ProductCode, String customerCode, String orgCode);

  /**
   * 根据客户或则组织、产品查询
   * @param customerCode
   * @return
   */
  List<DmsOrderMinimum> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(String customerCode, String orgCode, String status, Set<String> productCodes);
}

