package com.biz.crm.dms.business.order.minimum.local.service.internal;

import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.repository.DmsOrderMinimumRepository;
import com.biz.crm.dms.business.order.minimum.sdk.service.DmsOrderMinimumVoService;
import com.biz.crm.dms.business.order.minimum.sdk.vo.DmsOrderMinimumVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author: zengxingwang
 * @Date: 2022/4/28 10:56
 */
@Service
public class DmsOrderMinimumVoServiceImpl implements DmsOrderMinimumVoService {

  @Autowired(required = false)
  private DmsOrderMinimumRepository dmsOrderMinimumRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 根据客户或则组织、产品查询
   * @param customerCode
   * @param orgCode
   * @param status
   * @param productCodes
   * @return
   */
  @Override
  public List<DmsOrderMinimumVo> findByCustomerCodeOrOrgCodeAndStatusInProductCodes(String customerCode, String orgCode, String status, Set<String> productCodes) {
    if(StringUtils.isBlank(customerCode) && StringUtils.isBlank(orgCode)){
      return null;
    }
    if(StringUtils.isBlank(status) || CollectionUtils.isEmpty(productCodes)){
      return null;
    }
    List<DmsOrderMinimum> minimums = dmsOrderMinimumRepository.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(customerCode, orgCode, status, productCodes);
    Collection<DmsOrderMinimumVo> minimumVos = nebulaToolkitService.copyCollectionByWhiteList(minimums, DmsOrderMinimum.class, DmsOrderMinimumVo.class, HashSet.class, ArrayList.class);
    return Lists.newArrayList(minimumVos);
  }
}
