package com.biz.crm.dms.business.order.minimum.local.service.internal;

import com.biz.crm.dms.business.order.minimum.local.service.MinimumValidateMountRegister;
import com.biz.crm.dms.business.order.minimum.local.service.MinimumValidateMountVoService;
import com.biz.crm.dms.business.order.minimum.sdk.vo.MinimumValidateMountVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 订单起订量验证方式接口实现
 * @Author: zengxingwang
 * @Date: 2021/12/29 17:06
 */
@Service
public class MinimumValidateMountVoServiceImpl implements MinimumValidateMountVoService {

  @Autowired(required = false)
  private List<MinimumValidateMountRegister> minimumValidateMountRegisters;

  /**
   * 查询系统中存在的订单起订量验证方式
   * @return
   */
  @Override
  public List<MinimumValidateMountVo> findAll() {
    if (CollectionUtils.isEmpty(this.minimumValidateMountRegisters)) {
      return null;
    }
    List<MinimumValidateMountVo> list = Lists.newLinkedList();
    for (MinimumValidateMountRegister minimumValidateMountRegister : this.minimumValidateMountRegisters) {
      MinimumValidateMountVo vo = new MinimumValidateMountVo();
      vo.setFlag(minimumValidateMountRegister.getFlag());
      vo.setKey(minimumValidateMountRegister.getKey());
      vo.setName(minimumValidateMountRegister.getName());
      list.add(vo);
    }
    return list;
  }
}
