package com.biz.crm.dms.business.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.AppDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 客户订单分页dto
 *
 * @author hefan
 * @date 2022/04/14
 */
@Data
@ApiModel(value = "CustomerOrderPageDto", description = "客户订单分页dto")
public class CustomerOrderPageDto extends AppDto {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /** 订单状态 */
  @ApiModelProperty("订单状态集合")
  private List<String> orderStatus;

  /**
   * 下单时间-左
   */
  @ApiModelProperty("下单时间-左")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeLeft;

  /**
   * 下单时间-右
   */
  @ApiModelProperty("下单时间-右")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeRight;

  /** 关联编码 */
  @ApiModelProperty("关联编码，客户编码、组织编码、岗位编码等")
  private String relateCode;


}
