package com.biz.crm.dms.business.order.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * fixme：类名要改
 * -- 作为订单预览接口专用的dto
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailPayPreviewDto", description = "订单行内数据由来-预览dto--比如，本品选择的优惠政策")
public class OrderDetailPayPreviewDto {

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策CODE
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  private String originData;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  private String originDataType;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  private BigDecimal itemAmount;

  /**
   * 该扣项目金额数据的由来的别名
   * 比如：【政策优惠】选择了的促销政策的名称
   */
  @ApiModelProperty("该扣项目金额数据的由来的别名")
  private String originDataAlias;

}
