package com.biz.crm.dms.business.order.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 *
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailPreviewDto", description = "订单明细-预览dto")
public class OrderDetailPreviewDto {

  /**
   * 为true自动命中，为false不要优惠
   */
  @ApiModelProperty("是否自动命中优惠政策")
  private Boolean isAutoHit = true;

  /**
   * 明细类型 == 行项目类型
   */
  @ApiModelProperty("明细类型 == 行项目类型")
  private String itemType;

  /**
   * 行项目类型的特有业务编码：比如：货补商品有个【货补池编号】
   */
  @ApiModelProperty("行项目类型的特有业务编码：比如：货补商品有个【货补池编号】")
  private String itemCode;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  private BigDecimal presetUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  private BigDecimal salesAmount;

  /**
   * 行上该扣项目
   * --比如行上【本品】选择了的【促销政策】
   */
  @ApiModelProperty("订单明细行上该扣金额的项目")
  private List<OrderDetailPayPreviewDto> orderDetailPays;


}
