package com.biz.crm.dms.business.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.AppFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 订单主信息分页查询dto
 *
 * @author sunx
 * @date 2021-12-28 15:12:14
 */
@Data
@ApiModel(value = "OrderPaginationDto", description = "订单主信息分页查询dto")
public class OrderPaginationDto extends AppFlagOpDto {

  /** 订单编码 */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单编码集合
   */
  @ApiModelProperty("订单编码集合")
  private List<String> orderCodes;

  /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  private String orderSource;

  /** 关联编码 */
  @ApiModelProperty("关联编码，客户编码、组织编码、岗位编码等")
  private String relateCode;

  /** 客户名称 */
  @ApiModelProperty("关联名称，客户名称、组织名称、岗位名称等")
  private String relateName;

  /** 订单状态 */
  @ApiModelProperty("订单状态集合")
  private List<String> orderStatus;

  /**
   * 订单：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 是否显示
   */
  @ApiModelProperty("是否显示")
  private Boolean isShow;
}
