package com.biz.crm.dms.business.order.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 订单未发货-分页DTO
 *
 * @author he fan
 */
@Data
@ApiModel(value = "OrderUnshippedPageDto", description = "订单未发货-分页DTO")
public class OrderUnshippedPageDto {
  /**
   * 关联编码 【客户编码、组织编码】
   */
  @ApiModelProperty("关联编码 【客户编码、组织编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称、组织名称】
   */
  @ApiModelProperty("关联名称 【客户名称、组织名称】")
  private String relateName;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单编码集合
   */
  @ApiModelProperty("订单编码集合")
  private List<String> orderCodes;

  /**
   * 订单：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /** 订单状态 */
  @ApiModelProperty("订单状态集合")
  private List<String> orderStatus;

}
