package com.biz.crm.dms.business.order.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.AppFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * 购买历史-分页DTO
 *
 * @author he fan
 */
@Data
@ApiModel(value = "PurchaseHistoryPageDto", description = "购买历史-分页DTO")
public class PurchaseHistoryPageDto extends AppFlagOpDto {

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 购买次数
   */
  @ApiModelProperty("购买次数")
  private Integer times;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 商品/物料关键字(名称或者编码)
   */
  @ApiModelProperty("商品/物料关键字(名称或者编码)")
  private String goodsKeyWords;

  /**
   * 可用状态  Y表示可用 ，N表示不可用
   */
  @ApiModelProperty("可用状态")
  private String isUsable;
}
