package com.biz.crm.dms.business.order.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 订单明细行项目类型枚举
 *
 * @author sunx
 * @date 2021/12/28
 */
@Getter
@AllArgsConstructor
public enum OrderItemType {
  /** 订单明细行项目类型枚举 */
  DEFAULT("default", "default", "本品", "0"),
  GIFT("gift", "gift", "赠品", "1"),
  COMPENSATE("compensate", "compensate", "货补", "2"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
