package com.biz.crm.dms.business.order.sdk.service;

import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.order.sdk.vo.OrderConfirmVo;

import java.util.List;

/**
 * fixme: 赶紧写代码，先不管类名和位置了 。
 *
 * @author he fan
 */
public interface OrderConfirmService {

  /**
   * 订单提交--带结算信息的订单预览
   * --前端将所有信息传入【基本信息、商品信息、政策信息、结算信息】
   * --这里要做基本业务的校验
   * --不做任何数据记录处理
   * --留意，不在【配置管理】设置内的其他校验事项
   * --预计算、最终分摊结果展示
   *
   * @param order
   * @return
   */
  OrderConfirmVo handleSubmit(OrderConfirmDto order, List<OrderValidationProcessNodeEnum> exclude);

  /**
   * 订单确认
   *
   * @param order
   * @return
   */
  OrderConfirmVo handleConfirm(OrderConfirmDto order);

  /**
   * 订单确认 (且有支付方式判断）
   *
   * @param orderConfirmDto 订单确认dto
   * @return {@link OrderConfirmVo}
   */
  OrderConfirmVo handleConfirmWithPaymentMethod(OrderConfirmDto orderConfirmDto);

  /**
   * 创建与资源脱藕的订单
   * - 只创建订单
   * - 无资源占用
   * - 无流程审批
   *
   * @param order
   * @return
   */
  OrderConfirmVo handleConfirmWithoutResource(OrderConfirmDto order);

  /**
   * 暂存场景：创建与更新
   *
   * @param order
   * @return
   */
  OrderConfirmVo createOrUpdate(OrderConfirmDto order);

  /**
   * 根据当前登录客户去确认订单
   *
   * @param order 订单
   * @return {@link OrderConfirmVo}
   */
  OrderConfirmVo handleConfirmByCurrentCustomer(OrderConfirmDto order);

  /**
   * 根据当前登录客户使用部分费用提交订单
   * - 不生成真正的订单。
   * - 不校验最终支付
   *
   * @param order 订单
   * @return {@link OrderConfirmVo}
   */
  OrderConfirmVo handlePartSubmitByCurrentCustomer(OrderConfirmDto order);
}
