package com.biz.crm.dms.business.order.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author he fan
 */
public interface OrderVoService {

  /**
   * 根据订单编码集合查询
   *
   * @param orderCodes
   * @return
   */
  List<OrderVo> findByOrderCodes(List<String> orderCodes);

  /**
   * 更新订单状态,交付数量
   * 增加发货数量及根据已发货数量更新订单发货状态
   *
   * @param orderCode        订单编码
   * @param deliveryQuantity 发货数量
   * @param isAdd            是添加; true, 继续发货；false, 货被退了。
   * @return {@link OrderVo}
   */
  OrderVo updateOrderStatusByDeliveryQuantity(String orderCode, BigDecimal deliveryQuantity, Boolean isAdd);

  /**
   * 分页查询当前客户的数据
   *
   * @param pageable             分页
   * @param customerOrderPageDto 客户订单分页dto
   * @return {@link Page}<{@link OrderVo}>
   */
  Page<OrderVo> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto);

  /**
   * 发现通过id
   *
   * @param id id
   * @return {@link OrderVo}
   */
  OrderVo findById(String id);

  /**
   * 订单状态更新
   *
   * @param orderCode 订单编码
   * @param orderStatusEnum 订单状态
   * @param isShow 是否显示
   */
  void updateOrderStatusAndIsShowByOrderCode(String orderCode, OrderStatusEnum orderStatusEnum, Boolean isShow);
}
