package com.biz.crm.dms.business.order.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * vo中应该包含的内容
 * -- 揉价页面的元素
 * --
 * @author he fan
 */
@Data
@ApiModel(value = "OrderConfirmVo", description = "订单预览Vo")
public class OrderConfirmVo extends OrderPreviewVo {

  /**
   * 订单ID
   */
  @ApiModelProperty("订单ID")
  private String id;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  private String orderStatus;

  /**
   * 收货状态
   */
  @ApiModelProperty("收货状态")
  private String receiptStatus;

  /**
   * 货补扣减金额
   */
  @ApiModelProperty("货补扣减金额")
  private BigDecimal totalCompensatedAmount;

  /**
   * 商品总数
   */
  @ApiModelProperty("商品总数")
  private BigDecimal totalCountGoods;

  /**
   * 下单时间
   */
  @ApiModelProperty("下单时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 仓库编码 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  private String remark;

  /**
   * 期望到货时间
   */
  @ApiModelProperty("期望到货时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date expectedArrivalTime;

  /**
   * 是否显示
   */
  @ApiModelProperty("是否显示")
  private Boolean isShow;

  /**
   * 外部来源
   * - 比如换货单单号
   */
  @ApiModelProperty("外部来源")
  private String externalSources;

}
