package com.biz.crm.dms.business.order.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 订单明细行上该扣金额的项目
 * --命中的促销政策
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailPayPreviewVo", description = "订单明细行上该扣金额的项目的预览Vo")
public class OrderDetailPayPreviewVo {

  /**
   * 明细编码
   */
  @ApiModelProperty("明细编码")
  private String orderDetailCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  private BigDecimal itemAmount;
  
  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策集合
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  private String originData;

  /**
   * 该扣项目金额数据的由来的别名
   * 比如：【政策优惠】选择了的促销政策的名称
   */
  @ApiModelProperty("该扣项目金额数据的由来的别名")
  private String originDataAlias;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  private String originDataType;

  /**
   * 数据的由来【第二类型】、【模板类型】
   * 比如：【政策优惠】的政策是行内商品的【特价】类型。
   */
  @ApiModelProperty("数据的由来【第二类型】、【模板类型】")
  private String originDataTemplateType;

  /**
   * 项目可用
   */
  @ApiModelProperty("项目可用")
  private Boolean available;

  /**
   * 不可用原因
   */
  @ApiModelProperty("不可用原因")
  private String reason;

}
