package com.biz.crm.dms.business.order.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * vo中应该包含的内容
 * -- dto传来的数据
 * -- 命中的促销政策
 * @author he fan
 */
@Data
@ApiModel(value = "OrderPreviewVo", description = "订单预览Vo")
public class OrderPreviewVo {

  /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  private String orderSource;

  /**
   * 订单类别：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 提货方式
   */
  @ApiModelProperty("提货方式")
  private String pickUpWay;

  /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  private String detailedAddress;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  private String contactPhone;

  /**
   * 交货日期
   */
  @ApiModelProperty("交货日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date deliveryDate;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  private BigDecimal totalOrderAmount;

  /**
   * 本单实际支付 == 实际支付金额
   */
  @ApiModelProperty("本单实际支付 == 实际支付金额")
  private BigDecimal actualAmountPaid;

  //-------系统自动计算字段 且不用保存的----------------

  /**
   * 政策优惠金额
   */
  @ApiModelProperty("政策优惠金额 = 本单所有优惠金额汇总，商品优惠政策和整单优惠政策都包含")
  private BigDecimal policyDiscountAmount;

  /**
   * 存放订单里的货物
   */
  @ApiModelProperty("订单明细 == 存放订单里的货物")
  private List<OrderDetailPreviewVo> orderDetails;

  /**
   * 订单的总的该扣项目
   */
  @ApiModelProperty("订单的总的该扣项目")
  private List<OrderPayPreviewVo> orderPays;

  /**
   * 订单政策详情vo
   */
  @ApiModelProperty("订单政策详情vo")
  private List<OrderPolicyDetailVo> orderPolicyDetail;
}
