package com.biz.crm.dms.business.order.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单状态统计
 *
 * @author he fan
 * @date 2022/04/13
 */
@Data
@ApiModel(value = "OrderStatusStatisticsVo", description = "订单状态统计-vo")
public class OrderStatusStatisticsVo {

  /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  private String orderStatus;

  /**
   * 订单状态描述
   */
  @ApiModelProperty("订单状态描述")
  private String orderStatusDesc;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 订单数量
   */
  @ApiModelProperty("订单数量")
  private Integer orderCount;

}
