package com.biz.crm.dms.business.order.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 购买历史
 *
 * @author hefan
 * @date 2022/04/08
 */
@Data
@ApiModel(value = "PurchaseHistoryVo", description = "购买历史-vo")
public class PurchaseHistoryVo extends UuidVo {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /**
   * 商品图片
   */
  @ApiModelProperty("图片地址")
  private String urlAddress;

  /**
   * 单价
   */
  @ApiModelProperty("价格")
  private BigDecimal price;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 购买次数
   */
  @ApiModelProperty("购买次数")
  private Integer times;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 是否允销 */
  @ApiModelProperty("是否允销")
  private Boolean isAllowsale;

  /** 启禁用状态 */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /**
   * 可用状态  Y表示可用 ，N表示不可用
   */
  @ApiModelProperty("可用状态")
  private String isUsable;
}
