package com.biz.crm.dms.business.order.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * dto中应该包含的内容
 * -- 订单基本信息
 * -- 商品信息
 * -- 包含促销政策
 * -- 结算信息
 *
 * @author he fan
 */
@Data
@ApiModel(value = "OrderConfirmDto", description = "订单提交预览DTO")
public class OrderConfirmDto extends OrderPreviewDto {

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  /**
   * 订单支付方式
   * orderPaymentMethodEnum
   */
  @ApiModelProperty("订单支付方式")
  private String orderPaymentMethod;

  private boolean debug = false;

  /**
   * 暂存的草稿（0：否；1：是）
   */
  @ApiModelProperty("暂存的草稿（0：否；1：是）")
  private Boolean draft;

  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  private BigDecimal totalOrderAmount;

  /**
   * 仓库编码 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 期望到货时间
   */
  @ApiModelProperty("期望到货时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date expectedArrivalTime;

  /**
   * 是否显示
   */
  @ApiModelProperty("是否显示")
  private Boolean isShow;

  /**
   * 外部来源
   * - 比如换货单单号
   */
  @ApiModelProperty("外部来源")
  private String externalSources;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  private String remark;

  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;

}
