package com.biz.crm.dms.business.order.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 订单的总的记账项目
 * @author he fan
 */
@Data
@ApiModel(value = "OrderPayConfirmDto", description = "订单的总的记账项目DTO")
public class OrderPayConfirmDto {

  /**
   * 项目组类型：【0该扣项目、1支付项目】
   */
  @ApiModelProperty("项目组类型：【0该扣项目、1支付项目】")
  private Boolean itemGroupType;

  /**
   * 项目组的key
   */
  @ApiModelProperty("项目组的key")
  private String itemGroupKey;

  /**
   * 项目key
   */
  @ApiModelProperty("项目key")
  private String itemKey;

  /**
   * 项目名称
   */
  @ApiModelProperty("项目名称")
  private String itemName;

  /**
   * 项目金额
   */
  @ApiModelProperty("项目金额")
  private BigDecimal itemAmount;

}
