package com.biz.crm.dms.business.order.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 订单支付类型枚举
 *
 * @author sunx
 * @date 2021/12/27
 */
@Getter
@AllArgsConstructor
public enum OrderPayType {
  /** 订单支付类型枚举 */
  AMOUNT("amount", "amount", "总金额", "0"),
  POLICY("policy", "policy", "政策优惠金额", "1"),
  COMPENSATE("compensate", "compensate", "货补扣减", "2"),
  DISCOUNT("discount", "discount", "折扣扣减", "3"),
  ACTUAL("actual", "actual", "实际支付", "4"),
  CARD("card", "card", "预付款支付", "5"),
  CREDIT("credit", "credit", "授信支付", "6"),
  ;

  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
