package com.biz.crm.dms.business.order.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 订单类型枚举
 *
 * @author sunx
 * @date 2021/12/28
 */
@Getter
@AllArgsConstructor
public enum OrderType {
  /** 订单类型枚举 */
  STANDARD("standard", "standard", "标准订单", "0"),
  COMPENSATE("compensate", "compensate", "货补订单", "1"),
  FREE("free", "free", "免费订单", "2"),
  DISCOUNT("discount", "discount", "折扣订单", "3"),
  POLICY_CUSTOMER("policy_customer", "policy_customer", "促销物料订单-客户", "4"),
  POLICY_OTHER("policy_other", "policy_other", "促销物料订单-其他", "5"),
  ;

  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
