package com.biz.crm.dms.business.order.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailPayVo", description = "订单明细支付明细")
public class OrderDetailPayVo {

  /**
   * 明细编码
   */
  @ApiModelProperty("明细编码")
  private String orderDetailCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 该扣项目组的key
   */
  @ApiModelProperty("该扣项目组的key")
  private String itemGroupKey;

  /**
   * 该扣项目key
   */
  @ApiModelProperty("该扣项目key")
  private String itemKey;

  /**
   * 该扣项目名称
   */
  @ApiModelProperty("该扣项目名称")
  private String itemName;

  /**
   * 该扣项目金额（分摊）
   */
  @ApiModelProperty("该扣项目金额（分摊）")
  private BigDecimal itemAmount;

  /**
   * 该扣项目金额数据的由来
   * 比如：【政策优惠】选择了的促销政策CODE
   */
  @ApiModelProperty("该扣项目金额数据的由来")
  private String originData;

  /**
   * 该扣项目金额数据的由来的别名
   * 比如：【政策优惠】选择了的促销政策的名称
   */
  @ApiModelProperty("该扣项目金额数据的由来的别名")
  private String originDataAlias;

  /**
   * 数据的由来【类型】
   * 比如：【政策优惠】的政策是整单的，还是行内商品的。
   */
  @ApiModelProperty("数据的由来【类型】")
  private String originDataType;

}
