package com.biz.crm.dms.business.order.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author he fan
 */
@Data
@ApiModel(value = "OrderDetailVo", description = "订单明细")
public class OrderDetailVo {

  /**
   * 明细编码
   */
  @ApiModelProperty("明细编码")
  private String orderDetailCode;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 明细类型 == 行项目类型
   */
  @ApiModelProperty("明细类型 == 行项目类型")
  private String itemType;

  /**
   * 行项目类型的特有业务编码：比如：货补商品有个【货补池编号】
   */
  @ApiModelProperty("行项目类型的特有业务编码：比如：货补商品有个【货补池编号】")
  private String itemCode;

  /**
   * 商品/物料编码
   */
  @ApiModelProperty("商品/物料编码")
  private String goodsCode;

  /**
   * 商品/物料名称
   */
  @ApiModelProperty("商品/物料名称")
  private String goodsName;

  /**
   * 成本单价 == 系统预设单价
   */
  @ApiModelProperty("成本单价 == 系统预设单价")
  private BigDecimal presetUnitPrice;

  /**
   * 实际单价 = 组内分摊后的单价（正向）
   */
  @ApiModelProperty("实际单价 = 组内分摊后的单价（正向）")
  private BigDecimal actualUnitPrice;

  /**
   * 行内全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）【说明：没有业务性质,只做记录使用，不要参与业务开发】
   */
  @ApiModelProperty("行内全部分摊后的单价（平均价） = 实际支付金额（全部分摊后）/ 商品数量 （反向）")
  private BigDecimal averageUnitPrice;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String unite;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  private BigDecimal quantity;

  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  private BigDecimal availableStock;

  /**
   * 销售金额
   */
  @ApiModelProperty("销售金额")
  private BigDecimal salesAmount;

  /**
   * 实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）
   */
  @ApiModelProperty("实际支付金额（全部分摊后）== 销售金额 - 优惠金额 - 抵扣金额 （即，最终支付金额）")
  private BigDecimal shouldPaymentAmount;

  /**
   * 行上该扣项目
   */
  @ApiModelProperty("订单明细行上该扣金额的项目")
  private List<OrderDetailPayVo> orderDetailPays;

  /** 图片信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<OrderFileVo> pictureMediaList;

  /** 视频信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<OrderFileVo> videoMediaList;

}
