package com.biz.crm.dms.business.order.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * @author he fan
 */
@Data
@ApiModel(value = "OrderPayVo", description = "订单支付明细")
public class OrderPayVo {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 项目组类型：【0该扣项目、1支付项目】
   */
  @ApiModelProperty("项目组类型：【0该扣项目、1支付项目】")
  private Boolean itemGroupType;

  /**
   * 项目组的key
   */
  @ApiModelProperty("项目组的key")
  private String itemGroupKey;

  /**
   * 项目key
   */
  @ApiModelProperty("项目key")
  private String itemKey;

  /**
   * 项目名称
   */
  @ApiModelProperty("项目名称")
  private String itemName;

  /**
   * 项目金额
   */
  @ApiModelProperty("项目金额")
  private BigDecimal itemAmount;



}
