package com.biz.crm.dms.business.order.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

/**
 * @author he fan
 */
@Data
@ApiModel(value = "OrderPolicyDetailVo", description = "订单政策详情vo")
public class OrderPolicyDetailVo {

  /**
   * 促销政策名称
   */
  @ApiModelProperty("促销政策名称")
  private String originDataAlias;

  /**
   * 本品名称集合
   */
  @ApiModelProperty("本品名称集合")
  private List<String> goodsName = new LinkedList<>();

  /**
   * 赠品名称集合
   */
  @ApiModelProperty("赠品名称集合")
  private List<String> complimentaryGoodsName = new LinkedList<>();

  /**
   * 政策优惠金额
   */
  @ApiModelProperty("政策优惠金额")
  private BigDecimal itemAmount = BigDecimal.ZERO;

  /**
   * 报错说明
   */
  @ApiModelProperty("报错说明")
  private List<String> reason = new LinkedList<>();

}
