package com.biz.crm.dms.business.order.statistics.element.local.service.internal;

import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @description: 传入订单统计范围要素 组合注册器
 * @author: rentao
 * @date: 2022/1/15 14:20
 */
@Service
@Slf4j
public class OrderStatisticsServiceImpl implements OrderStatisticsService {

  @Override
  public BigDecimal getFeeCount(List<BigDecimal> orderStatisticsMoneys) {
    return Optional.of(orderStatisticsMoneys).orElse(Lists.newArrayList()).stream().reduce(BigDecimal.ZERO,BigDecimal::add);
  }
}
