package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import java.math.BigDecimal;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

/**
 * @description: 订单政策要素注册实现
 * @author: rentao
 * @date: 2022/1/15 13:43
 */
@Service
@Slf4j
public class PolicyGoodsElementRegisterImpl implements OrderStatisticsElementRegister {

  @Override
  public String getOrderStatisticsElementCode() {
    return OrderStatisticsElementConstant.POLICY_GOODS;
  }

  @Override
  public String getOrderStatisticsElementName() {
    return "政策优惠金额";
  }

  @Override
  public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
    Validate.notNull(orderVerificationContext, "政策优惠金额统计金额时:订单数据为空");
    OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
    Validate.notNull(orderTabulateDto, "政策优惠金额统计金额时:订单分摊计算后的vo为空");
    return orderTabulateDto.getPolicyDiscountAmount();
  }
}
