/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DiscountGoodsElementRegisterImpl
implements OrderStatisticsElementRegister {
    private static final Logger log = LoggerFactory.getLogger(DiscountGoodsElementRegisterImpl.class);
    @Autowired(required=false)
    @Qualifier(value="DiscountApportionTallyItemRegister")
    private TallyItemRegister tallyItemRegister;

    public String getOrderStatisticsElementCode() {
        return "discountGoods";
    }

    public String getOrderStatisticsElementName() {
        return "\u6298\u6263";
    }

    public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
        Validate.notNull((Object)orderVerificationContext, (String)"\u6298\u6263\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderDto orderDto = orderVerificationContext.getOrderDto();
        Validate.notNull((Object)orderDto, (String)"\u6298\u6263\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u5206\u644a\u8ba1\u7b97\u540e\u7684vo\u4e3a\u7a7a", (Object[])new Object[0]);
        List orderPays = orderDto.getOrderPays();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orderPays) ? 1 : 0) != 0, (String)"\u6298\u6263\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.tallyItemRegister, (String)"\u6298\u6263\u8d39\u7528\u6c60\u5206\u644a\u6ce8\u518c\u5668\u83b7\u53d6\u5931\u8d25\uff01", (Object[])new Object[0]);
        String itemKey = this.tallyItemRegister.findTallyItemRegisterModel().getItemKey();
        BigDecimal reduce = orderPays.stream().filter(orderPayDto -> itemKey.equals(orderPayDto.getItemKey()) && Objects.nonNull(orderPayDto.getItemAmount())).map(OrderPayDto::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return reduce;
    }

    public BigDecimal getFeeQuantity(List<OrderDetailDto> products) {
        return Optional.of(products).orElse(Lists.newArrayList()).stream().map(OrderDetailDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

