/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NormalGoodsElementRegisterImpl
implements OrderStatisticsElementRegister {
    private static final Logger log = LoggerFactory.getLogger(NormalGoodsElementRegisterImpl.class);

    public String getOrderStatisticsElementCode() {
        return "normalGoods";
    }

    public String getOrderStatisticsElementName() {
        return "\u672c\u54c1";
    }

    public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
        Validate.notNull((Object)orderVerificationContext, (String)"\u672c\u54c1\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
        Validate.notNull((Object)orderTabulateDto, (String)"\u672c\u54c1\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u5206\u644a\u8ba1\u7b97\u540e\u7684vo\u4e3a\u7a7a", (Object[])new Object[0]);
        List orderDetails = orderTabulateDto.getOrderDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orderDetails) ? 1 : 0) != 0, (String)"\u672c\u54c1\u7edf\u8ba1\u91d1\u989d\u65f6:\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal reduce = orderDetails.stream().filter(orderDetailTabulateDto -> ItemTypeEnum.NORMAL_GOODS.getDictCode().equals(orderDetailTabulateDto.getItemType()) && Objects.nonNull(orderDetailTabulateDto.getSalesAmount())).map(OrderDetailTabulateDto::getSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return reduce;
    }

    public BigDecimal getFeeQuantity(List<OrderDetailDto> products) {
        return Optional.of(products).orElse(Lists.newArrayList()).stream().map(OrderDetailDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

