package com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 订单统计要素vo
 * @author: rentao
 * @date: 2022/1/15 13:30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeeStatisticsModelVo", description = "费用池统计范围模型Vo")
public class OrderStatisticsVo {

  /** 费用统计范围编码 */
  @ApiModelProperty(name = "orderStatisticsCode", value = "订单统计要素编码", required = true)
  private String orderStatisticsCode;

  /** 费用统计范围名称 */
  @ApiModelProperty(name = "orderStatisticsName", value = "订单统计要素名称", required = true)
  private String orderStatisticsName;

  /** 费用统计范围排序 */
  @ApiModelProperty(name = "orderStatisticsSort", value = "订单统计要素排序", required = true)
  private Integer orderStatisticsSort;
}
