package com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;

import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import java.math.BigDecimal;
import java.util.List;

/**
 * @description: 订单统计要素注册器
 *            包含 本品 赠品 货补 折扣 政策优惠金额等 可以扩展
 * @author: rentao
 * @date: 2022/1/15 13:27
 */
public interface OrderStatisticsElementRegister {

  /**
   * 订单统计要素编码
   *
   * @author rentao
   * @date
   */
  String getOrderStatisticsElementCode();

  /**
   * 订单统计要素名称
   *
   * @author rentao
   * @date
   */
  String getOrderStatisticsElementName();

  /**
   * 费用销售范围统计金额
   *
   * @author rentao
   * @date
   */
  default BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext){
    return  null;
  };

  /**
   * 费用销售范围统计数量
   *
   * @author rentao
   * @date
   */
 default BigDecimal getFeeQuantity(List<OrderDetailDto> products){
   return  BigDecimal.ZERO;
 };

}
